/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.debug;

import frc.emul.mc6809.Operand;
import frc.emul.mc6809.Regs;
import frc.emul.util.Utils;
import frc.emul.vectrex.debug.TraceEntry;
import frc.emul.vectrex.debug.UITraceEntries;

public class UITraceEntry {
    private static final Operand[] REGS = new Operand[]{Operand.REG_PC, Operand.REG_A, Operand.REG_B, Operand.REG_X, Operand.REG_Y, Operand.REG_DP, Operand.REG_CC, Operand.REG_U, Operand.REG_S};
    private final UITraceEntries owner;
    private final TraceEntry entry;
    private final int index;
    private String[] regs;
    private boolean[] regsChanges;
    private Boolean stackChange;
    private Boolean bankChange;
    private String stack;
    private String codeBytes;
    private String codeSource;
    private String codeComments;

    public UITraceEntry(UITraceEntries uITraceEntries, TraceEntry traceEntry, int n) {
        this.owner = uITraceEntries;
        this.entry = traceEntry;
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public TraceEntry getEntry() {
        return this.entry;
    }

    public UITraceEntry getPreviousUIEntry() {
        return this.owner.getUIEntry(this.index - 1);
    }

    public UITraceEntry getNextUIEntry() {
        return this.owner.getUIEntry(this.index + 1);
    }

    public String[] getRegisters() {
        this.init();
        return this.regs;
    }

    public String getStack() {
        this.init();
        return this.stack;
    }

    public String getCodeSource() {
        this.init();
        return this.codeSource;
    }

    public String getCodeBytes() {
        this.init();
        return this.codeBytes;
    }

    public String getCodeComments() {
        this.init();
        return this.codeComments;
    }

    public boolean hasStackContentChanged() {
        if (this.stackChange == null) {
            this.computeChanges();
        }
        return this.stackChange;
    }

    public boolean hasBankContentChanged() {
        if (this.bankChange == null) {
            this.computeChanges();
        }
        return this.bankChange;
    }

    public boolean[] getRegisterChanges() {
        if (this.regsChanges == null) {
            this.computeChanges();
        }
        return this.regsChanges;
    }

    private void init() {
        if (this.regs != null) {
            return;
        }
        Regs regs = this.entry.getRegs();
        this.regs = new String[]{Utils.HEX(4, regs.PC()), Utils.HEX(2, regs.A()), Utils.HEX(2, regs.B()), Utils.HEX(4, regs.X()), Utils.HEX(4, regs.Y()), Utils.HEX(2, regs.DP()), Utils.getRegCCFlags(regs.CC(), new StringBuffer(8)).toString(), Utils.HEX(4, regs.U()), Utils.HEX(4, regs.S())};
        this.stack = Utils.dump(this.entry.getStack());
        try {
            StringBuffer[] stringBufferArray = this.owner.disassemble(this);
            this.codeBytes = stringBufferArray[0].toString();
            this.codeSource = stringBufferArray[1].toString();
            this.codeComments = stringBufferArray[2].toString();
        }
        catch (Exception exception) {
            this.codeComments = "*** DISASSEMBLER ERROR ***";
            this.codeSource = "*** DISASSEMBLER ERROR ***";
            this.codeBytes = Utils.dump(this.entry.getCode());
            System.err.println("Exception while disassembling [" + this.codeBytes + "] at address $" + Utils.HEX(4, regs.PC()) + " :");
            exception.printStackTrace();
        }
    }

    private void computeChanges() {
        this.stackChange = Boolean.FALSE;
        try {
            TraceEntry traceEntry = this.getPreviousUIEntry().getEntry();
            Regs regs = traceEntry.getRegs();
            Regs regs2 = this.entry.getRegs();
            boolean[] blArray = new boolean[9];
            blArray[1] = regs.A() != regs2.A();
            blArray[2] = regs.B() != regs2.B();
            blArray[3] = regs.X() != regs2.X();
            blArray[4] = regs.Y() != regs2.Y();
            blArray[5] = regs.DP() != regs2.DP();
            blArray[6] = regs.CC() != regs2.CC();
            blArray[7] = regs.U() != regs2.U();
            blArray[8] = regs.S() != regs2.S();
            this.regsChanges = blArray;
            byte[] byArray = traceEntry.getStack();
            byte[] byArray2 = this.entry.getStack();
            int n = byArray.length;
            while (--n >= 0) {
                if (byArray[n] == byArray2[n]) continue;
                this.stackChange = Boolean.TRUE;
                break;
            }
            this.bankChange = traceEntry.getBank() != this.entry.getBank();
        }
        catch (NullPointerException nullPointerException) {
            this.regsChanges = new boolean[9];
            this.bankChange = Boolean.FALSE;
        }
    }

    public static Operand getRegisterKind(int n) {
        return REGS[n];
    }

    public static int getRegisterChars(int n) {
        switch (REGS[n]) {
            case REG_A: 
            case REG_B: 
            case REG_DP: {
                return 2;
            }
            case REG_X: 
            case REG_Y: 
            case REG_U: 
            case REG_S: 
            case REG_PC: {
                return 4;
            }
            case REG_CC: {
                return 7;
            }
        }
        return 0;
    }
}

